unit PPSaver_SimpleDemo_;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, PPSaver, ExtCtrls, ComCtrls;

type
  TfrmDemo = class(TForm)
    btnAVIMux: TButton;
    Label4: TLabel;
    StatusBar1: TStatusBar;
    PropertyPageSaver: TPropertyPageSaver;
    procedure btnAVIMuxClick(Sender: TObject);
    procedure PropertyPageSaverPropertiesRestored(Sender: TObject);
    procedure PropertyPageSaverPropertiesSaved(Sender: TObject);
  private
  public
  end;

var
  frmDemo: TfrmDemo;

implementation

uses ActiveX, ComObj;

{$R *.DFM}

const
    CLSID_AVIMux: TGUID = '{E2510970-F137-11CE-8B67-00AA00A3F1A6}';

//------------------------------------------------------------------------------
procedure TfrmDemo.btnAVIMuxClick(Sender: TObject);
//------------------------------------------------------------------------------
var
   pUnk: IUnknown;
begin
   if CoCreateInstance (CLSID_AVIMux, nil, CLSCTX_INPROC_SERVER or CLSCTX_LOCAL_SERVER, IUnknown, pUnk) = S_OK then begin
      if PropertyPageSaver.Activate (pUnk) then begin  // if the dialog has been sucessfully activated
         PropertyPageSaver.RestoreProperties;          // we restore the properties
         if PropertyPageSaver.ShowDialog then begin    // we show the dialog
            PropertyPageSaver.SaveProperties;          // we save the new properties
         end;
         PropertyPageSaver.Deactivate;                 // and finally we deactivate the dialog
      end;
      pUnk := nil;
   end;
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.PropertyPageSaverPropertiesRestored(Sender: TObject);
//------------------------------------------------------------------------------
begin
   StatusBar1.SimpleText := 'Properties restored from: ' + PropertyPageSaver.GetFullRegistryPath;
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.PropertyPageSaverPropertiesSaved(Sender: TObject);
//------------------------------------------------------------------------------
begin
   StatusBar1.SimpleText := 'Properties saved at: ' + PropertyPageSaver.GetFullRegistryPath;
end;

end.
